import keras.preprocessing.text
import numpy as np
import pandas as pd
np.random.seed(1337)  # for reproducibility
from keras.preprocessing import sequence
from keras.models import Sequential
from keras.layers.core import Dense, Activation
from keras.layers.embeddings import Embedding
from keras.layers.recurrent import LSTM
from sklearn.metrics import (precision_score, recall_score,f1_score, accuracy_score,mean_squared_error,mean_absolute_error)
from sklearn import metrics
from sklearn.metrics import roc_auc_score
from keras.utils.np_utils import to_categorical
from sklearn.cross_validation import train_test_split
from keras.layers import Dropout

print("Loading")

traindata = pd.read_csv('space/CDMC2016_AndroidLabel.Train.csv', header=None)
testdata = pd.read_csv('train_test.csv', header=None)

x = traindata.iloc[:,1]
y = traindata.iloc[:,0]
xt = testdata.iloc[:,1]
yt = testdata.iloc[:,0]


tk = keras.preprocessing.text.Tokenizer(nb_words=5000, filters=keras.preprocessing.text.base_filter(), lower=True, split=",")
tk.fit_on_texts(x)
X_train = tk.texts_to_sequences(x)


tk = keras.preprocessing.text.Tokenizer(nb_words=5000, filters=keras.preprocessing.text.base_filter(), lower=True, split=",")
tk.fit_on_texts(xt)
X_test = tk.texts_to_sequences(xt)



X_train=np.array(X_train)
X_test=np.array(X_test)


y_train = np.array(y)
y_test = np.array(yt)

batch_size = 64
max_len = 500
print "max_len ", max_len
print('Pad sequences (samples x time)')

X_train = sequence.pad_sequences(X_train, maxlen=max_len)
X_test = sequence.pad_sequences(X_test, maxlen=max_len)

max_features = 5000
model = Sequential()
print('Build model...')
embedding_vecor_length = 32

model = Sequential()
model.add(Embedding(max_features, embedding_vecor_length, input_length=max_len))
model.add(Dropout(0.2))
model.add(LSTM(100))
model.add(Dropout(0.2))
model.add(Dense(1))
model.add(Activation('sigmoid'))

model.compile(loss='binary_crossentropy', optimizer='adam',metrics=['accuracy'])
print(model.summary())

model.fit(X_train, y_train, batch_size=batch_size, nb_epoch=50,validation_data=(X_test, y_test),shuffle=True)
score, acc = model.evaluate(X_test, y_test)

print('Test score:', score)
print('Test accuracy:', acc)
y_pred = model.predict_classes(X_test)
np.savetxt('output.txt', np.transpose([y_test,y_pred]), fmt='%01d')

